<?php
session_start();
require_once __DIR__ . '/../../config.php';

header('Content-Type: application/json');

if (!function_exists('chat_db')) {
    http_response_code(500);
    echo json_encode(['error' => 'config_error', 'message' => 'chat_db() is not defined. Run install.php first.']);
    exit;
}

$pdo = chat_db();
if (!$pdo) {
    http_response_code(500);
    echo json_encode(['error' => 'db_error']);
    exit;
}


if (empty($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'not_logged_in']);
    exit;
}

$me             = (int) $_SESSION['user_id'];
$conversationId = (int) ($_POST['conversation_id'] ?? 0);
$lastId         = (int) ($_POST['last_id'] ?? 0);

if ($conversationId <= 0 || $lastId <= 0) {
    http_response_code(400);
    echo json_encode(['error' => 'invalid_input']);
    exit;
}

$st = $pdo->prepare("SELECT user1_id,user2_id FROM conversations WHERE id = :id");
$st->execute([':id' => $conversationId]);
$conv = $st->fetch();

if (!$conv || ($conv['user1_id'] != $me && $conv['user2_id'] != $me)) {
    http_response_code(403);
    echo json_encode(['error' => 'no_access']);
    exit;
}

$pdo->beginTransaction();

// mark messages as seen
$st = $pdo->prepare("UPDATE messages
                     SET status='seen', seen_at = NOW()
                     WHERE conversation_id = :cid
                       AND id <= :last
                       AND sender_id <> :me
                       AND status <> 'seen'");
$st->execute([':cid' => $conversationId, ':last' => $lastId, ':me' => $me]);

// reset unread counter for this user
if ($me == (int)$conv['user1_id']) {
    $st2 = $pdo->prepare("UPDATE conversations SET unread_user1 = 0 WHERE id = :cid");
} else {
    $st2 = $pdo->prepare("UPDATE conversations SET unread_user2 = 0 WHERE id = :cid");
}
$st2->execute([':cid' => $conversationId]);

$pdo->commit();

echo json_encode(['ok' => true]);
