<?php
// chat_module/public/chat_list_demo.php
session_start();

// For the demo we just check if user_id exists.
// In your real site, you must log in users and set $_SESSION['user_id'] accordingly.
if (empty($_SESSION['user_id'])) {
    echo "<p>You must be logged in (with \$_SESSION['user_id'] set) to use the chat demo.</p>";
    exit;
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Chat Demo</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link rel="stylesheet" href="../assets/css/chat.css">
</head>
<body>
<div class="tg-app">
  <header class="tg-header">
    <button class="tg-menu-btn">☰</button>
    <div class="tg-title">Chat &amp; Earn</div>
    <div class="tg-header-actions">
      <button class="tg-icon-btn">🔒</button>
      <button class="tg-icon-btn">🔍</button>
    </div>
  </header>

  <div class="tg-tabs">
    <button class="tg-tab tg-tab-active" data-filter="all">All Chats</button>
    <button class="tg-tab" data-filter="unread">Unread</button>
  </div>

  <div class="tg-layout">
    <aside class="tg-chat-list" id="chatList"></aside>
    <main class="tg-chat-main">
      <div class="tg-chat-empty" id="chatEmpty">Select a chat to start messaging.</div>
      <div class="tg-chat-window hidden" id="chatWindow">
        <div class="tg-chat-header" id="chatHeader"></div>
        <div class="tg-chat-messages" id="chatMessages"></div>
        <div class="tg-chat-input-bar">
          <input type="text" id="chatInput" placeholder="Type a message…">
          <button id="chatSendBtn">Send</button>
        </div>
      </div>
    </main>
  </div>

  <button class="tg-fab">✎</button>
</div>

<script>
  window.CHAT_API_BASE = '../api/chat';
  window.LOGGED_IN_USER_ID = <?php echo (int)$_SESSION['user_id']; ?>;
</script>
<script src="../assets/js/chat.js"></script>
</body>
</html>
